[Setup]
;-- Main Setup Information
 AppName                  = SQL-Exchange Client
 AppVerName               = SQL-Exchange Client 1.0.3.2
 AppCopyright             = Copyright  1995-2004 NetWorkDLS
 DefaultDirName           = {pf}\NetWorkDLS\SQL-Exchange\Client
 DefaultGroupName         = NetWorkDLS\SQL-Exchange Client
 UninstallDisplayIcon     = {app}\SQLEClient.Exe
 UninstallStyle           = Modern
 WizardImageFile          = Resources\LgSetup.bmp
 WizardSmallImageFile     = Resources\SmSetup.bmp
 PrivilegesRequired       = PowerUser
 Uninstallable            = Yes
 AppMutex                 = SQL-Exchange Client
 LicenseFile              = Resources\EULA.txt
 Compression              = BZIP/9
 OutputBaseFilename       = Setup
;UninstallLogMode         = OverWrite
 UninstallRestartComputer = Yes
 DisableStartupPrompt     = Yes
 DirExistsWarning         = No

;-- Windows 2000 & XP (Support Dialog)
 AppPublisher    = NetWorkDLS
 AppPublisherURL = http://www.NetWorkDLS.com/
 AppUpdatesURL   = http://www.NetWorkDLS.com/
 AppVersion      = 1.0.3.2

[Files]
 Source: "..\Debug\SQLEClient.Exe";            DestDir: "{app}";    Flags: IgnoreVersion RestartReplace;
 Source: "ServiceCtl\Release\ServiceCtl.Exe";  DestDir: "{app}";    Flags: IgnoreVersion;
 Source: "AutoUpdate\Release\AutoUpdate.Exe";  DestDir: "{app}";    Flags: IgnoreVersion;

 Source: "Resources\EULA.txt";                DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\OpenDlg.ico";             DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Start.ico";               DestDir: "{app}";     Flags: IgnoreVersion;
 Source: "Resources\Stop.ico";                DestDir: "{app}";     Flags: IgnoreVersion;

 Source: "SQL\SQLExch_Statements.sql";        DestDir: "{app}\SQL"; Flags: IgnoreVersion;

 Source: "Libraries\NSWFL.Dll";               DestDir: "{app}";     Flags: RestartReplace;

[Icons]
 Name: "{group}\Open Client";    Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/openmaindialog"; IconFilename: "{app}\OpenDlg.ico"
 Name: "{group}\Start Service";  Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/start";          IconFilename: "{app}\Start.ico"
 Name: "{group}\Stop Service";   Filename: "{app}\ServiceCtl.Exe";  WorkingDir: "{app}"; Parameters: "/stop";           IconFilename: "{app}\Stop.ico"

[Dirs]
 Name: "{app}\Logs"

[Registry]
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; Flags: UninsDeleteKey

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "Path";              ValueType: String; ValueData: "{app}";                     Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLDataFiles";      ValueType: String; ValueData: "C:\Program Files\Microsoft SQL Server\MSSQL\Data"; Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "DefaultDBO";        ValueType: String; ValueData: "DBO";                       Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ReplicationDB";     ValueType: String; ValueData: "SQLExch_Replication";       Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SessionLogDir";     ValueType: String; ValueData: "{app}\Logs";                Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ExportFileTemp";    ValueType: String; ValueData: "{app}\Logs\LastExport.txt"; Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLDriver";         ValueType: String; ValueData: "{{SQL Server}";             Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLPassword";       ValueType: String; ValueData: "";                          Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLServer";         ValueType: String; ValueData: "";                          Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLUserID";         ValueType: String; ValueData: "sa";                        Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "SQLDatabase";       ValueType: String; ValueData: "";                          Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "CompanyName";       ValueType: String; ValueData: "";                          Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "CompanyPassword";   ValueType: String; ValueData: "";                          Flags: CreateValueIfDoesntExist;
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ServerAddress";     ValueType: String; ValueData: "SQLExch.com";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ShowSplashScreen";  ValueType: Dword;  ValueData: "1";                         Flags: CreateValueIfDoesntExist;

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "AuthString";        ValueType: String; ValueData: "trIeSPiUhouDlUwRLe5hie2H5awRoupiaDi8zI0fo3Y7u6R703r7e6rLacrouChi";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "AuthKey";           ValueType: String; ValueData: "6riupiekieB8uphiuspi0tr6azl2piAth6us6ieko2zoap2818UviapHlEvo5joe";

 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ServerPort";        ValueType: Dword;  ValueData: "6632";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "ConnectInterval";   ValueType: Dword;  ValueData: "5";
 Root: HKLM; Subkey: "Software\NetWorkDLS\SQL-Exchange\Client"; ValueName: "PingTimeoutMS";     ValueType: Dword;  ValueData: "60000";

[Run]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/install";
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/start";

[UninstallRun]
 Filename: "{app}\ServiceCtl.EXE"; Parameters: "/delete"; RunOnceId: "DeleteService"; MinVersion: 0, 4.0

